//
//  Copyright © 2025 Kyle Hughes. All rights reserved.
//  SPDX-License-Identifier: MIT
//

import Synchronization

@available(macOS 15.0, iOS 18.0, tvOS 18.0, watchOS 11.0, *)
final class SendableCounter: Sendable {
    // MARK: Internal Instance Properties
    
    var value: Int {
        mutex.withLock {
            $0
        }
    }
    
    // MARK: Private Instance Properties
    
    private let mutex: Mutex<Int>
    
    // MARK: Internal Initialization
    
    init(value: Int = 0) {
        mutex = Mutex(value)
    }
    
    // MARK: Internal Instance Interface
    
    func add(_ delta: Int) -> Int {
        mutex.withLock {
            $0 += delta
            
            return $0
        }
    }
    
    func add(_ a: Int, _ b: Int) -> Int {
        mutex.withLock {
            $0 += a + b
            
            return $0
        }
    }
}
